#ifdef GL_ES
precision mediump float;

varying vec3 normal;
varying vec2 vTexCoord;

vec4 fragColor;
#else
in vec3 normal;
in vec2 vTexCoord;

out vec4 fragColor;
#endif
uniform sampler2D colorTex;
uniform sampler2D lightTex;
uniform float brightness;
uniform vec4 inColor;

uniform vec3 lightSource4;
uniform vec3 lightSource4HV;

void main()
{
    vec3 norm = normalize(normal);
    float lambert = dot(norm, lightSource4);
	
    float specular = dot(norm, lightSource4HV) * 0.35;
    float diffuse = lambert * (0.75 * 0.75) * brightness;
		
#ifdef GL_ES
    vec4 tColor = texture2D(colorTex, vTexCoord.st);
    vec3 fColor = (texture2D(lightTex, vTexCoord.st).r * inColor.a) * inColor.rgb;
#else
    vec4 tColor = texture(colorTex, vTexCoord.st);
    vec3 fColor = (texture(lightTex, vTexCoord.st).r * inColor.a) * inColor.rgb;
#endif
    fragColor = vec4((tColor.rgb * diffuse) + vec3(specular * tColor.a) + fColor, 1.0);
#ifdef GL_ES
    gl_FragColor = fragColor;
#endif
}
